function AddModelTonicParams()
%% Add parameters related to tonic current
    
    global GTonicGABAModels
    
    AddPanel('Model (Tonic)');
    
    %% Parameters of tonic current
    AddRatScalar('VTonicGABA', -55, 'mV', 'Reverse potential of tonic current');
    desc = {'Conductance of tonic current.', ...
        'If %dynamicGTonicGABA is checked, then this parameter gives the initial condition.'};
    AddRatScalar('GTonicGABA', 0.44, 'mS / cm2', desc);
    AddRatScalar('v_rev_i', 'VTonicGABA', 'mV', 'Reverse potential of IGABA');
    AddRatScalar('DeltaVGABA', -10, 'mV', 'Difference between reverse potential of interneuron and piramidal neurons');
    AddRatScalar('AlphaTonic', 0.5, '', 'Modulator of conductance of excitability neurons', true, 'AlphaTonic > 0');
    
    %% GTonicGABA-related parameters
    desc = {'The type of GTonicGABA model', ...
        '<b>unchecked:</b> <i>no time dependency, it''s a constant equal %GTonicGABA</i>', ...
        '<b>checked:</b> <i>the function of time defined by an ODE dependent on %GTonicGABAModel</i>'};
    AddBoolScalar('dynamicGTonicGABA', true, desc);
    
    desc1 = {'GTonic is defined by the equation: GTonic[t] = y[t]', ...
        'where', ...
        'y''[t] = %num_i * %Af * (mean_Frequency_i[t - %freqDelay] + %basicFrequency) - %Gpump * (y[t] - %GTonicGABAControl)', ...
        'y[0] = %GTonicGABA'};
    desc2 = {'GTonic is defined by the equation: GTonic[t] = %G0 + %Rate * y[t]', ...
        'where', ...
        'y''[t] = 1 / %dt / %V * %N / %Na * mean_num_spikes_i[t - %freqDelay] - %Gpump * (y[t] - %GABAb)', ...
        'y[0] = (%GTonicGABA - %G0) / %Rate'};
    AddList('GTonicGABAModel', fieldnames(GTonicGABAModels), GTonicGABAModels.First, 'Dynamic GTonicGABA model', {desc1, desc2}, 'dynamicGTonicGABA');
    
    relPredPat = 'dynamicGTonicGABA && GTonicGABAModel == GTonicGABAModels.%s';
    
    relPred = sprintf(relPredPat, 'First');
    AddRatScalar('Af', 0.0000005, 'mM', 'Rate of GABA concnetration on frequency', relPred);
    AddRatScalar('GTonicGABAControl', 0.1, 'mS / cm2', 'Rating tonic conductance', relPred);
    AddRatScalar('basicFrequency', 5, 'kHz', 'The basic frequency', relPred);
    
    relPred = sprintf(relPredPat, 'Second');
    AddRatScalar('G0', 0.2, 'nS', 'Shift parameter', relPred);
    AddRatScalar('Rate', 110, 'nS / mM', 'Scale parameter', relPred);
    AddPosRatScalar('V', 1e-18, 'liter', 'Effective volume', relPred);
    AddPosIntScalar('N', 3000, 'Number of molecules release during of single AP', relPred);
    AddPosRatScalar('Na', 6.022e20, '1 / mM', 'Avogadro number', relPred);
    AddRatScalar('GABAb', 0.1, 'M', 'Rating tonic concentration', relPred);
    
    AddRatScalar('Gpump', 0.002, '1 / s', 'Rate of GABA pumping', 'dynamicGTonicGABA');
    
    AddBoolScalar('enableFreqDelay', true, 'Whether to delay the frequency parameter', 'dynamicGTonicGABA');
    AddPosRatScalar('freqDelay', '50000 * dt', 'ms', 'The delay for i-network frequency', 'dynamicGTonicGABA && enableFreqDelay', 'round(freqDelay / dt) > 0');
    
end