function AddRngParams()

    AddPanel('RNG');
    
    AddRatScalar('eUpperBound', 0, '', 'Maximum value of u_e', true, 'eUpperBound >= 0');
    AddRatScalar('iUpperBound', 0, '', 'Maximum value of u_i', true, 'iUpperBound >= 0');
   
    AddIntScalar('hostSeed', 5489, 'Seed for Matlab random number generator');
    
    desc = {'Random Number Generator to use', ...
            '<b>unchecked:</b> <i>fine-grained 64-bit Random Number Generator</i>', ...
            '<b>checked:</b> <i>coarse-grained 32-bit Random Number Generator</i>'};
    AddBoolScalar('use32BitRng', true, desc);
    
    conds = {'((~scalTest && (length(scmSeeds) >= np * nt * 4)) || (scalTest && (length(scmSeeds) >= maxNP * maxNT * 4)))', ...
             'all(scmSeeds(:) >= intmin) && all(scmSeeds(:) <= intmax) && all(scmSeeds(:) ~= 0)', ...
             '(numel(unique(scmSeeds)) == length(scmSeeds))', ...
             'isempty(intersect(scmSeeds, uSeeds)) && isempty(intersect(scmSeeds, releaseSeeds))'};
    valpred = strjoin(conds, '&&');
    relpred = '~isempty(intersect([scmType_ee, scmType_ie, scmType_ei, scmType_ii], [ScmTypes.KrnDense, ScmTypes.KrnSparse, ScmTypes.KrnOneBit, ScmTypes.KrnInPlace]))';
    AddIntVector('scmSeeds', '-1 : -1 : -1000 * 4', 'Random number generator seeds to generate matrices in HPC kernel', relpred, valpred);
    
    conds = {'((~scalTest && (length(uSeeds) >= np * nt)) || (scalTest && (length(uSeeds) >= maxNP * maxNT)))', ...
             'all(uSeeds(:) >= intmin) && all(uSeeds(:) <= intmax) && all(uSeeds(:) ~= 0)', ...
             '(numel(unique(uSeeds)) == length(uSeeds))', ...
             'isempty(intersect(uSeeds, releaseSeeds))', ...
             '(~isempty(intersect([scmType_ee, scmType_ie, scmType_ei, scmType_ii], [ScmTypes.AllZeros, ScmTypes.AllEqual, ScmTypes.HstDense, ScmTypes.HstSparse])) || isempty(intersect(uSeeds, scmSeeds)))'};
    valpred = strjoin(conds, '&&');
    AddIntVector('uSeeds', '1 : 1000', 'Random number generator seeds to generate vectors u_e and u_i on each iteration', true, valpred);
    
    conds = {'((~scalTest && (length(releaseSeeds) >= np * nt)) || (scalTest && (length(releaseSeeds) >= maxNP * maxNT)))', ...
             'all(releaseSeeds(:) >= intmin) && all(releaseSeeds(:) <= intmax) && all(releaseSeeds(:) ~= 0)', ...
             '(numel(unique(releaseSeeds)) == length(releaseSeeds))', ...
             'isempty(intersect(uSeeds, releaseSeeds))', ...
             '(~isempty(intersect([scmType_ee, scmType_ie, scmType_ei, scmType_ii], [ScmTypes.AllZeros, ScmTypes.AllEqual, ScmTypes.HstDense, ScmTypes.HstSparse])) || isempty(intersect(releaseSeeds, scmSeeds)))'};
    valpred = strjoin(conds, '&&');
    AddIntVector('releaseSeeds', '2001 : 3000', 'Random number generator seeds to support release probabilities (i.e. space-time-random connections between neurons)', true, valpred);
    
end