function AddModelTonicParams_for_UTILITY_ComputeMaxModelSize()
%% Add parameters related to tonic current
    
    AddPanel('Model (Tonic)');

    %% GTonicGABA-related parameters
    desc = {'The type of GTonicGABA model', ...
        '<b>unchecked:</b> <i>no time dependency (it''s a constant)</i>;', ...
        '<b>checked:</b> <i>the function of time defined by an ODE</i>'};
    AddBoolScalar('dynamicGTonicGABA', true, desc);
    
    AddBoolScalar('enableFreqDelay', true, 'Whether to delay the frequency parameter', 'dynamicGTonicGABA');
    AddPosRatScalar('freqDelay', '50000 * dt', 'ms', 'The delay for i-network frequency', 'dynamicGTonicGABA && enableFreqDelay', 'round(freqDelay / dt) > 0');
    
end