function GenerateSrcFile(modFileName, parametersBlocks, out_path)

    srcTplPathName = fullfile(cd, 'Core', 'ModFileUtils', 'CppFilesGenerators', 'Templates', 'SrcTemplate.cpp');

    srcTplFile = fopen(srcTplPathName, 'r');

    if srcTplFile == -1
        error('Couldn''t open the next file for reading:\n%s', srcTplPathName);
    end

    srcFile = {};

    notInitCurrentParams = FindAllCurrentsInBlocks(parametersBlocks);
            
    while true

        tline = fgetl(srcTplFile);

        if tline == -1
            break
        end

        if strfind(tline, '%INCLUDE_HEADER')

            srcFile{end + 1, 1} = ['#include "', modFileName, '.h"']; %#ok<*AGROW>
            srcFile{end + 1, 1} = '';

        elseif strfind(tline, '%CTOR_SIGNATURE')

            srcFile{end + 1} = [modFileName, '<T>::', modFileName, '()'];

        elseif strfind(tline, '%INIT_BASE_NUMS')
            
            % Get numCurrents
            numCurrents = length(notInitCurrentParams);
            
            % Get numStates
            scope = parametersBlocks.STATE;
            if ~isempty(scope)
                params = ParseStateBlock(scope);
                numParams = 0;
                if isempty(params)
                    numStates = numParams;
                else
                    for i = 1 : length(params)
                        if isempty(strfind(params{i}, '['))
                            numParams = numParams + 1;
                        end
                    end        
                    numStates = numParams;
                end
            else
                numStates = 0;
            end
            
            srcFile{end + 1} = sprintf('    this->_numCurrents = %i;', numCurrents);
            srcFile{end + 1} = sprintf('    this->_numStates = %i;', numStates);
            
        elseif strfind(tline, '%INIT_BASE_PTRS_SIGNATURE')
            
            srcFile{end + 1} = ['void ', modFileName, '<T>::initBasePtrs()'];
            
        elseif strfind(tline, '%INIT_CURRENTS')
            
            srcFile{end + 1} = '    this->_currents = new T*[this->_numCurrents];';
           
            currentIdx = 0;
            for i = 1 : length(notInitCurrentParams)
                if isempty(strfind(notInitCurrentParams{i}, '['))
                    srcFile{end + 1} = sprintf('    this->_currents[%i] = &%s;', currentIdx, notInitCurrentParams{i});
                    currentIdx = currentIdx + 1;
                end
            end

        elseif strfind(tline, '%INIT_STATES')

            scope = parametersBlocks.STATE;
            if ~isempty(scope)
                stateParams = ParseStateBlock(scope);

                if ~isempty(stateParams)
                    srcFile{end + 1} = '    this->_states = new T*[this->_numStates];';
                end
                countStates = -1;
                for i = 1 : length(stateParams)
                     if isempty(strfind(stateParams{i}, '['))
                         countStates = countStates + 1;
                         srcFile{end + 1} = ...
                             ['    this->_states[', int2str(countStates), '] = &', stateParams{i}, ';'];
                     end
                end
            end
            
        elseif strfind(tline, '%INIT_DERIVATIVES')
            
            scope = parametersBlocks.STATE;
            if ~isempty(scope)
                stateParams = ParseStateBlock(scope);
                
                if ~isempty(stateParams)
                    srcFile{end + 1} = '    this->_derivatives = new T*[this->_numStates];';
                end
                countStates = -1;
                for i = 1 : length(stateParams)
                    if isempty(strfind(stateParams{i}, '['))
                        countStates = countStates + 1;
                        srcFile{end + 1} = ...
                            ['    this->_derivatives[', int2str(countStates), '] = &', stateParams{i}, '_rhp;'];
                    end
                end
            end
            
        elseif strfind(tline, '%INITIAL_SIGNATURE')

            srcFile{end + 1} = ['void ', modFileName, '<T>::init()'];

        elseif strfind(tline, '%INITIAL_BODY')
            
            block = parametersBlocks.INITIAL;
            
            i = 1;
            while i < length(block)
                
                cStr = block{i};
                
                if strfind(cStr, 'INITIAL')
                    
                    i = i + 1;
                    continue
                    
                elseif strcmp(strtrim(cStr), 'VERBATIM')
          
                    [i, srcFile] = ParseVerbatimBlock(block, i, srcFile);

                else
                    cStr = TranslateLineOfCode(cStr);
                    
                    if isempty(cStr)
                        srcFile{end + 1} = '';
                    elseif strfind(cStr, 'LOCAL')
                        srcFile{end + 1} = regexprep(cStr, 'LOCAL', 'T');
                        
                    elseif strfind(cStr, 'FROM')
                        
                        srcFile{end + 1} = ParseForCycleHdr(cStr);
                        
                    elseif strfind(cStr, '=')
                        if cStr(end) == '}'
                            srcFile{end + 1} = [cStr(1 : end - 1), ';}'];
                        elseif cStr(end) == '{'
                            srcFile{end + 1} = cStr;   
                        else
                            srcFile{end + 1} = cStr;
                        end
                    else
                        if cStr(end) == ')'
                            srcFile{end + 1} = cStr;
                        else
                            srcFile{end + 1} = cStr;
                        end
                    end
                    
                    i = i + 1; 
                end
            end

        elseif strfind(tline, '%BREAKPOINT_SIGNATURE')

            srcFile{end + 1} = ['void ', modFileName, '<T>::currents()'];

        elseif strfind(tline, '%BREAKPOINT_BODY')

            block = parametersBlocks.BREAKPOINT;
            
            i = 1;
            while i < length(block)
                
                cStr = block{i};
                
                if strfind(cStr, 'BREAKPOINT') 
                    i = i + 1;
                    continue
                elseif isempty(cStr) || ~isempty(strfind(cStr, 'SOLVE')) || strcmp(cStr(1), ':')
                    i = i + 1;
                    continue
                elseif strfind(cStr, 'LOCAL')
                    i = i + 1;
                    srcFile{end + 1} = [regexprep(cStr, 'LOCAL', 'T'), ';'];
                elseif strcmp(strtrim(cStr), 'VERBATIM')
                    
                    [i, srcFile] = ParseVerbatimBlock(block, i, srcFile);
                    
                else
                    i = i + 1;
                    srcFile{end + 1} = TranslateLineOfCode(cStr);
                end
            end
            
        elseif strfind(tline, '%DERIVATIVE_SIGNATURE')

            srcFile{end + 1} = ['void ', modFileName, '<T>::states()'];

        elseif strfind(tline, '%DERIVATIVE_BODY')

            block = parametersBlocks.DERIVATIVE;

            for i = 2 : length(block) - 1
                if strfind(block{i}, '=')
                    cline = regexprep(block{i}, '\s*', '');
                    line = ['    ', regexprep(cline, '''', '_rhp')];
                else
                    line = ['    ', regexprep(block{i}, '\s*', '')];
                end
                srcFile{end + 1} = TranslateLineOfCode(line);
            end

        elseif strfind(tline, '%PROCEDURE_DEFINITIONS')

            srcFile = ParseProcDefs(parametersBlocks.PROCEDURE, srcFile, modFileName);
            
        elseif strfind(tline, '%FUNCTION_DEFINITIONS')
            
            srcFile = ParseFuncDefs(parametersBlocks.FUNCTION, srcFile, modFileName);

        elseif strfind(tline, '%TEMPLATE_INSTANTIATION_FLOAT')

            srcFile{end + 1} = ['class ', modFileName, '<float>;'];

        elseif strfind(tline, '%TEMPLATE_INSTANTIATION_DOUBLE')

            srcFile{end + 1} = ['class ', modFileName, '<double>;'];
            
        else
            
            srcFile{end + 1} = tline;
            
        end
    end
        
    fclose(srcTplFile);

    SaveLinesToFile(srcFile, out_path, [modFileName, '.cpp']);
    
end

function outStr = ParseForCycleHdr(inStr)

    leftIdx = strfind(inStr, 'FROM');
    leftIdx = leftIdx(1) + 5;
    rigthIdx = strfind(inStr, '=');
    rigthIdx = rigthIdx(1) - 1;
    counterName = strtrim(inStr(leftIdx : rigthIdx));

    leftIdx = rigthIdx + 2;
    rigthIdx = strfind(inStr, 'TO');
    rigthIdx = rigthIdx(1) - 1;
    startValue = strtrim(inStr(leftIdx : rigthIdx));

    leftIdx = rigthIdx + 3;
    rigthIdx = strfind(inStr, '{');
    rigthIdx = rigthIdx(1) - 1;
    endValue = strtrim(inStr(leftIdx : rigthIdx));

    outStr = ['    for (int ', counterName, ' = ', startValue, ...
        '; ', counterName, ' <= ', endValue, ';', ...
        ' ++', counterName, ') {'];
    
    outStr = regexprep(outStr, '\(T\)', '');
end

function [i, srcFile] = ParseVerbatimBlock(block, i, srcFile)

    srcFile{end + 1} = '    // VERBATIM';

    i = i + 1;
    cStr = block{i};

    while ~strcmp(strtrim(cStr), 'ENDVERBATIM')
        srcFile{end + 1} = cStr;
        i = i + 1;
        cStr = block{i};
    end
    i = i + 1;
    
    srcFile{end + 1} = '    // ENDVERBATIM';
    
end

function srcFile = ParseProcDefs(procBlocks, srcFile, modFileName)

    for idx = 1 : length(procBlocks)

        proc = procBlocks{idx};
        [name, formal_params, proc_body] = ParseProcedureBlock(proc);

        srcFile{end + 1} = '';
        srcFile{end + 1} = 'template <typename T>';

        if isempty(formal_params{1})
            srcFile{end + 1} = ['void ', modFileName, '<T>::', name, '()'];
        else 
            var_names = '';
            for i = 1 : length(formal_params) - 1
                var_names = [var_names, 'T ', formal_params{i}, ', '];
            end
            var_names = [var_names, 'T ', formal_params{end}];
            srcFile{end + 1} = ['void ', modFileName, '<T>::', name, '(', var_names, ')'];
        end

        srcFile{end + 1} = '{';

        for i = 1 : length(proc_body)

            tmpStr = strsplit(proc_body{i}, ':');
            tmpStr = tmpStr{1};
            tmpStr = TranslateLineOfCode(tmpStr);

            if isempty(tmpStr) || ~isempty(strfind(tmpStr, 'PROCEDURE')) || ...
                    ~isempty(strfind(tmpStr, 'TABLE')) || ...
                    ~isempty(strfind(tmpStr, 'UNITSOFF'))

                continue
            elseif strfind(tmpStr, 'LOCAL')
                srcFile{end + 1} = regexprep(tmpStr, 'LOCAL', 'T');

            elseif strfind(tmpStr, 'FROM')

                srcFile{end + 1} = ParseForCycleHdr(tmpStr);

            elseif strfind(tmpStr, '=')
                if tmpStr(end) == '}'
                    srcFile{end + 1} = [tmpStr(1 : end - 1), ';}'];
                elseif tmpStr(end) == '{'
                    srcFile{end + 1} = cStr;   
                else
                    srcFile{end + 1} = tmpStr;
                end
            else
                srcFile{end + 1} = tmpStr;
            end
        end
    end 

end

function srcFile = ParseFuncDefs(funcBlocks, srcFile, modFileName)

    for idx = 1 : length(funcBlocks)

        func = funcBlocks{idx};
        [name, formal_params, func_body] = ParseFunctionBlock(func);

        srcFile{end + 1} = '';
        srcFile{end + 1} = 'template <typename T>';

        if isempty(formal_params{1})
            srcFile{end + 1} = ['T ', modFileName, '<T>::', name, '()'];
        else 
            var_names = '';
            for i = 1 : length(formal_params) - 1
                var_names = [var_names, 'T ', formal_params{i}, ', '];
            end
            var_names = [var_names, 'T ', formal_params{end}];
            srcFile{end + 1} = ['T ', modFileName, '<T>::', name, '(', var_names, ')'];
        end

        srcFile{end + 1} = '{';
        srcFile{end + 1} = ['    T _', name, ';'];

        for i = 1 : length(func_body)

            tmpStr = strsplit(func_body{i}, ':');
            tmpStr = tmpStr{1};
            tmpStr = TranslateLineOfCode(tmpStr);

            if isempty(tmpStr) || ~isempty(strfind(tmpStr, 'FUNCTION')) || ...
                    ~isempty(strfind(tmpStr, 'TABLE')) || ...
                    ~isempty(strfind(tmpStr, 'UNITSOFF'))

                continue
                
            elseif strfind(tmpStr, 'LOCAL')
                
                srcFile{end + 1} = regexprep(tmpStr, 'LOCAL', 'T');

            elseif strfind(tmpStr, 'FROM')

                srcFile{end + 1} = ParseForCycleHdr(tmpStr);

            elseif strfind(tmpStr, '=')
                if strfind(tmpStr, name)
                    tmpStr = regexprep(tmpStr, name, ['_', name]);
                end
                if tmpStr(end) == '}'
                    srcFile{end + 1} = [tmpStr(1 : end - 1), '}'];
                elseif tmpStr(end) == '{'
                    srcFile{end + 1} = cStr;   
                else
                    srcFile{end + 1} = tmpStr;
                end
            elseif i == length(func_body)
                srcFile{end + 1} = ['    return _', name, ';'];
                srcFile{end + 1} = tmpStr;
            else
                srcFile{end + 1} = tmpStr;
            end
        end
    end
    
end
