function lines = ProcessIncludeDirectivesRecursively(lines, cline, tmpPath)

    if strfind(cline, 'INCLUDE')
        scopeIdx = strfind(cline, '"');
        includeFileName = cline(scopeIdx(1) + 1 : scopeIdx(end) - 1);
        fInclude = fopen(fullfile(tmpPath, includeFileName), 'r');
        if fInclude == -1
            error('Cannot open include file for reading');
        end
        while ~feof(fInclude)
            tline = fgetl(fInclude); 
            
            if strfind(tline, 'INCLUDE')
                lines = ProcessIncludeDirectivesRecursively(lines, tline, tmpPath);
            else
                lines{end + 1, 1} = tline; %#ok<AGROW>
            end
        end
        fclose(fInclude);
    else
        lines{end + 1, 1} = cline; 
    end
    
end