function [exePresent, md5Equal, newMd5FileName] = CheckWorkerAppState()
%% Check whether EXE file is present for HPC kernel.
%  Compute MD5-code for new MOD-currents and compare it with the old code stored in HPC kernel.

    % Check if the file "gs.exe" or "gs_fakeMPI" is present
    exePresent = CheckExeExists();
    
    % Compute MD5-code based on content of the selected MOD-files and values of the assigned parameters
    hashStr = GetMd5ForModData();
    
    % Compare the new hash code with the old one
    newMd5FileName = [hashStr, '.md5'];
    md5Equal = CheckMd5File(newMd5FileName);
    
end