function AddHpcParams_for_UTILITY_ComputeMaxModelSize()
    
    global ScmTypes
    global remoteHPC
    
    AddPanel('HPC');
    
    desc = {'On/off scalability test', ...
            '<b>unchecked:</b> <i>run HPC kernel once for number of processes equal %np and number of threads equal %nt</i>', ...
            '<b>checked:</b> <i>run HPC kernel sequentially for number of processes equal %minNP, %minNP + 1, ..., %maxNP and number of threads equal 1, 2, ..., %maxNT'};
    AddBoolScalar('scalTest', false, desc);
    AddPosIntScalar('np', 1, 'Number of MPI processes', '~scalTest');
    AddPosIntScalar('minNP', 1, 'Minimum number of MPI processes', 'scalTest');
    
    remoteHPC = true;
    
    AddStringVector('loadedNodes', GetAvailableNodesStr(), 'List of nodes to run simulation on', true, 'valPred_loadedNodes(loadedNodes)');
    
    scmTypesList = fieldnames(ScmTypes);
    scmTypesDesc = {'The matrix is not generated explicitly. <br>All elements are zeros', ...
                    'The matrix is not generated explicitly. <br>All elements are equal', ...
                    'The matrix is generated in Matlab and saved to input MAT-file with other data. <br>The matrix is generated in dense form', ...
                    'The matrix is generated in Matlab and saved to input MAT-file with other data. <br>The matrix is generated in sparse form', ...
                    'The matrix is generated in HPC kernel before 1st iteration already in distributed form. <br>An element of the matrix is stored in floating-point-number format', ...
                    'The matrix is generated in HPC kernel before 1st iteration already in distributed form. <br>The matrix is generated in sparse form', ...
                    'The matrix is generated in HPC kernel before 1st iteration already in distributed form. <br>An element of the matrix is stored in one bit', ...
                    'The matrix is re-generated in HPC kernel on each iteration'};
    AddList('scmType_ee', scmTypesList, ScmTypes.KrnDense, 'Type of synaptic conductance matrix', scmTypesDesc);
    AddList('scmType_ei', scmTypesList, ScmTypes.KrnDense, 'Type of synaptic conductance matrix', scmTypesDesc);
    AddList('scmType_ie', scmTypesList, ScmTypes.KrnDense, 'Type of synaptic conductance matrix', scmTypesDesc);
    AddList('scmType_ii', scmTypesList, ScmTypes.KrnDense, 'Type of synaptic conductance matrix', scmTypesDesc);
    
    AddBoolScalar('useSPA', true, 'Use Single Precision Arithmetics instead of double precision one');
    
    desc = {'In what mode matrices of presynaptic voltage history will be presented', ...
            '<b>unchecked:</b> <i>local mode</i>', ...
            '<b>checked:</b> <i>distributed mode</i>'};
    AddBoolScalar('distMatPVH', false, desc);
    
    desc = {'Whether to save intermediate data file "intermediate.mat that makes it possible to stop simulation and continue afterwards from the same point.', ...
            'The file is saved when:', ...
            '1) specified %t_final is reached;', ...
            '2) termination is requested by user;', ...
            '3) %saveBackupMats == true and current iteration number is evenly divisible by %backupPeriodIter.'};
    AddBoolScalar('saveIntermMat', true, desc, '~distMatPVH');
    
    desc = {'The limit for number of spikes per one simulation session.', ...
            'It will be used to preallocate the following arrays in HPC kernel: idx_e_spikes, t_e_spikes and other.', ...
            'The limit for number of spikes of a type is computed in HPC kernel as:', ...
            'max_num_spikes_e = int32(%num_e * %m_steps * %max_num_spikes_e_factor);'};
    AddPosRatScalar('max_num_spikes_e_factor', 0.02, '', desc);
    
    desc = {'The limit for number of spikes per one simulation session.', ...
            'It will be used to preallocate the following arrays in HPC kernel: idx_i_spikes, t_i_spikes and other.', ...
            'The limit for number of spikes of a type is computed in HPC kernel as:', ...
            'max_num_spikes_i = int32(%num_i * %m_steps * %max_num_spikes_i_factor);'};
    AddPosRatScalar('max_num_spikes_i_factor', 0.02, '', desc);
    
end