: FRAPlcium flux gap junction. 2018
: 04 01 2018
: ModifiFRAPtion of ifrap

NEURON {
    POINT_PROCESS GapFRAP

    USEION frapion READ frapioni WRITE ifrapion VALENCE 1

    RANGE TimeRelex,  ifrap, BasicFRAP, fluxion, jd, ControlGap
    POINTER gapFRAPP
}

UNITS {
    (molar) =	(1/liter)
    (mM) =	(millimolar)
    (um) =	(micron)
    (mA) =	(milliamp)
    FARADAY =	(faraday)	(10000 coulomb)
    PI = (pi)	(1)
}

PARAMETER {
    TimeRelex = 10000 (ms) 
    BasicFRAP = 1 (mM)


	
}

ASSIGNED {
    frapioni (mM)
    gapFRAPP (mM)
    diam (um)
    iFRAPgap (nanoamp)
    fluxion (mM ms)
    ifrapion : so you FRAPn plot the FRAPlcium current generated by this mechanism
}

BREAKPOINT {
    fluxion=BasicFRAP*TimeRelex 
	
    fluxion=BasicFRAP*TimeRelex 
    ifrapion = (((frapioni - gapFRAPP)/fluxion)*(2*FARADAY))            : Gap junction between Astrocytes
}